*-------------------------------------------------------------------------------
/* title : Export tex tables with estimated results
   input : $output_dta/`model'.ster	for each model (table-column) estimated 
   output: $output_tex/`table'.tex" for each results table 
		   $output_log/`table'.log" log files for each results table 
		   $output_tex/Table4_Overidentification_pvalue.tex"
		   $output_tex/Table4_Underidentification_pvalue.tex" */
*-------------------------------------------------------------------------------

*===============================================================================
* Set up
*===============================================================================
*--------------------------SET-UP & READ DIRECTORIES----------------------------
cd												// Current directory of code
do "[0.0] directories.do"

*===============================================================================
* Table 2 - Baseline
*===============================================================================
local table Table2
local columns Baseline FE_ct FE_jt LabourTiming IC Proxies00 Proxies00downIMupEX

foreach name of local columns {
	estimates use "$output_dta/`name'" 	//Original model with all Proxies.
	estimates store `name' 				//Store results to create columns below.
}

* Tex
estout `columns' using "$output_tex/`table'.tex", replace drop(offsh* insh* shh* sub* J) ///
		cells(b(star fmt(3)) se(par fmt(3))) starlevels($^{\ast}$ .10 $^{\ast\ast}$ .05 $^{\ast\ast\ast}$ .01) ///
		stats(N, labels("Observations") fmt(%9.0fc)) mlabels(, none) collabels(, none) eqlabels(, none) ///
		rename(omega "$\!\omega_{it-1}\$" downOFF "$\!{downIM}_{jct-1}\$" upIN "$\!{upEX}_{jct-1}\$" upOFF "$\!{upIM}_{jct-1}\$" downIN "$\!{downEX}_{jct-1}\$") ///
		varlabels(, end(\addlinespace) nolast elist("$\!{downEX}_{jct-1}\$" \midrule)) style(tex) substitute("\!" "")

* Log
cap log using "$output_log/`table'.log", replace
estout `columns', cells(b(star fmt(3)) se(par fmt(3))) starlevels(* .10 ** .05 *** .01) stats(N, labels("Observations") fmt(%9.0fc))
cap log close

*===============================================================================
* Table 4 - IV
*===============================================================================
local table Table4
local columns Baseline IV IVnoUS

foreach name of local columns {
	estimates use "$output_dta/`name'" 	//Original model with all Proxies.
	estimates store `name' 				//Store results to create columns below.
}

* Tex
estout `columns' using "$output_tex/`table'.tex", replace drop(omega offsh* insh* shh* sub* J) ///
		cells(b(star fmt(3)) se(par fmt(3))) starlevels($^{\ast}$ .10 $^{\ast\ast}$ .05 $^{\ast\ast\ast}$ .01) ///
		/*stats(N, labels("Observations") fmt(%9.0fc))*/ mlabels(, none) collabels(, none) eqlabels(, none) ///
		rename(downOFF "$\!{downIM}_{jct-1}\$" upIN "$\!{upEX}_{jct-1}\$" upOFF "$\!{upIM}_{jct-1}\$" downIN "$\!{downEX}_{jct-1}\$") ///
		varlabels(, end(\addlinespace) nolast elist("$\!{EXdown}_{jct-1}\$" \midrule)) style(tex) substitute("\!" "")

* Log
cap log using "$output_log/`table'.log", replace
estout `columns', cells(b(star fmt(3)) se(par fmt(3))) starlevels(* .10 ** .05 *** .01) stats(N, labels("Observations") fmt(%9.0fc)) drop(J)
cap log close

*===============================================================================
* Table 4; columns 1-3 - Overidentification test statistic
*===============================================================================
/*Hansen (1982) test statistic; Under the null hypothesis, the overidentifying 
  restrictions are valid. The estimator of the J distribution can then be used
  to form critical values for test statistics*/

foreach model in Baseline IV IVnoUS {
	
	* Load data
	if "`model'"=="Baseline" use "$output_dta/`model'.dta", clear
	else merge 1:1 _n using "$output_dta/`model'.dta" 
	estimates use "$output_dta/`model'" 					// Original model with all Proxies.
	
	* Rejection frequency of bootstrap J test statistic
	* Note: The test rejects the null at size a if p≤a
	gen I = 0 												// Indicator 
	replace I = 1 if J>_b[J] & !missing(J)
	gegen sumI = sum(I)
	gen p_`model' = sumI/_N 								// Percentile in the bootstrap distribution of J
	keep p*
}

* Tex Table
gen all = 1
estpost tabstat p*, by(all) nototal 
estout . using "$output_tex/Table4_Overidentification_pvalue.tex", replace style(tex) mlabels(, none) collabels(, none) eqlabels(, none) ///
				cells("p_Baseline(fmt(%9.3fc)) p_IV(fmt(%9.3fc)) p_IVnoUS(fmt(%9.3fc))") ///
				rename(1 "Overidentification p-value")

*===============================================================================
* Table 4; columns 1-3 - Underidentification test statistic
*===============================================================================
/*Established by Windmeijer (2021). Under the null hypothesis that the model is
  underidentified, i.e. the instruments have insufficient explanatory power to 
  predict the endogenous variable(s). The underidentification test is equivalent 
  to an overidentification test when regressing any endogenous variable on the 
  remaining regressors of the original model using the same set of instruments.
  Thus, for each endogenous explanatory variable the overidentification Hansen-J
  test for the relevant auxiliary model serves as an underidentification test 
  under the H0 hypothesis that the model is underidentified. The test relies on 
  the choice of the left-hand side variable, and thus only informs whether the 
  particular endogenous variable is poorly predicted by instruments. The HansenJ 
  statistic is computed as before. The estimator of the distribution of J can 
  then be used to form critical values */

foreach Uvar in down0dIM up0dEX up0dIM down0dEX {
	foreach model in "" _IV _IVnoUS {
	
		* Load data
		if "`model'"=="" use "$output_dta/Utest`model'_`Uvar'.dta", clear
		else merge 1:1 _n using "$output_dta/Utest`model'_`Uvar'.dta" 
		estimates use "$output_dta/Utest`model'_`Uvar'" 				// Original model with all Proxies.
		
		* Rejection frequency of bootstrap J test statistic
		* Note: The test rejects the null at size a if p≤a
		gen I = 0 														// Indicator 
		replace I = 1 if J>_b[J] & !missing(J)
		gegen sumI = sum(I)
		gen p`model' = sumI/_N 											// Percentile in the bootstrap distribution of J
		keep p*
	}
	
	* Store
	keep if _n==1
	gen Uvar = "`Uvar'"
	save "$temp/Utest_`Uvar'.dta", replace
}

* Add tex table (row) with number of observations
replace p = e(N)
replace p_IV = e(N)
replace p_IVnoUS = e(N)
replace Uvar = "Observations"
estpost tabstat p*, by(Uvar) nototal
estout . using "$output_tex/Table4_Observations.tex", replace style(tex) mlabels(, none) collabels(, none) eqlabels(, none) ///
		 cells("p(fmt(%9.0fc)) p_IV(fmt(%9.0fc)) p_IVnoUS(fmt(%9.0fc))")

* Append p-values for each endogenous variable
foreach Uvar in down0dIM up0dEX up0dIM down0dEX {
	if "`Uvar'"=="down0dIM" use "$temp/Utest_`Uvar'.dta", clear
	else append using "$temp/Utest_`Uvar'.dta"
	erase "$temp/Utest_`Uvar'.dta"
}

* Tex table
estpost tabstat p*, by(Uvar) nototal 
estout . using "$output_tex/Table4_Underidentification_pvalue.tex", replace style(tex) mlabels(, none) collabels(, none) eqlabels(, none) 	///
		 cells("p(fmt(%9.3fc)) p_IV(fmt(%9.3fc)) p_IVnoUS(fmt(%9.3fc))") ///
		 rename(down0dIM "$\quad{downIM}_{jct-1}\$" up0dEX "$\quad{upEX}_{jct-1}\$" up0dIM "$\quad{upIM}_{jct-1}\$" down0dEX "$\quad{downEX}_{jct-1}\$") ///
		 order("$\quad{downIM}_{jct-1}\$" "$\quad{upEX}_{jct-1}\$" "$\quad{upIM}_{jct-1}\$" "$\quad{downEX}_{jct-1}\$")


*===============================================================================
* Table 5 - Heterogeneity with dummy variable (D) interactions
*===============================================================================
local table Table5
local columns Baseline DomesticLinks_D Downstream_D LowTech_D L_D DownstreamLowTech_D DownstreamL_D

foreach name of local columns {
	estimates use "$output_dta/`name'" 	//Original model with all Proxies.
	estimates store `name' 				//Store results to create columns below.
}

* Tex
estout `columns' using "$output_tex/`table'.tex", replace drop(omega* offsh* insh* shh* sub* J D) ///
		cells(b(star fmt(3)) se(par fmt(3))) starlevels($^{\ast}$ .10 $^{\ast\ast}$ .05 $^{\ast\ast\ast}$ .01) ///
		stats(N, labels("Observations") fmt(%9.0fc)) mlabels(, none) collabels(, none) eqlabels(, none) ///
		rename(downOFF "$\!{downIM}_{jct-1}\$" upIN "$\!{upEX}_{jct-1}\$" upOFF "$\!{upIM}_{jct-1}\$" downIN "$\!{downEX}_{jct-1}\$" /// 
			 downOFF_D "$\!D*{downIM}_{jct-1}\$" upIN_D "$\!D*{upEX}_{jct-1}\$" upOFF_D "$\!D*{upIM}_{jct-1}\$" downIN_D "$\!D*{downEX}_{jct-1}\$") ///
		varlabels(, end(\addlinespace) nolast elist("$\!D*{downEX}_{jct-1}\$" \midrule)) style(tex) substitute("\!" "") 

* Log
cap log using "$output_log/`table'.log", replace
estout `columns', cells(b(star fmt(3)) se(par fmt(3))) starlevels(* .10 ** .05 *** .01) stats(N, labels("Observations") fmt(%9.0fc)) drop(J)
cap log close

*===============================================================================
* Table 6 - Mechanisms
*===============================================================================
local table Table6
local columns Baseline CEEC_D Developed_Split_CEEC Developed_Split_WEC

foreach name of local columns {
	estimates use "$output_dta/`name'" 	//Original model with all Proxies.
	estimates store `name' 				//Store results to create columns below.
}

* Tex
estout `columns' using "$output_tex/`table'.tex", replace drop(omega* offsh* insh* shh* sub* J) ///
		cells(b(star fmt(3)) se(par fmt(3))) starlevels($^{\ast}$ .10 $^{\ast\ast}$ .05 $^{\ast\ast\ast}$ .01) ///
		stats(N, labels("Observations") fmt(%9.0fc)) mlabels(, none) collabels(, none) eqlabels(, none) ///
		rename(downOFF "$\!{downIM}_{jct-1}\$" upIN "$\!{upEX}_{jct-1}\$" upOFF "$\!{upIM}_{jct-1}\$" downIN "$\!{downEX}_{jct-1}\$" ///
			 downOFF_D "$\!D*{downIM}_{jct-1}\$" upIN_D "$\!D*{upEX}_{jct-1}\$" upOFF_D "$\!D*{upIM}_{jct-1}\$" downIN_D "$\!D*{EXdown}_{jct-1}\$" /// 
			 downOFF_dvlpng "$\!{downIM}_{jct-1}^{dvlping}\$" upIN_dvlpng "$\!{upEX}_{jct-1}^{dvlping}\$" ///
			 upOFF_dvlpng "$\!{upIM}_{jct-1}^{dvlping}\$" downIN_dvlpng "$\!{downEX}_{jct-1}^{dvlping}\$") ///
		varlabels(, end(\addlinespace) nolast elist("$\!D*{downEX}_{jct-1}\$" \midrule)) style(tex) substitute("\!" "")

* Log
cap log using "$output_log/`table'.log", replace
estout `columns', cells(b(star fmt(3)) se(par fmt(3))) starlevels(* .10 ** .05 *** .01) stats(N, labels("Observations") fmt(%9.0fc)) drop(J)
cap log close



*===============================================================================
* Online Appendix Table - Proxies
*===============================================================================
local table OnlineAppendix_TableD3
local columns Baseline NoII down0dIM up0dEX up0dIM down0dEX down0dIM_NoII up0dEX_NoII up0dIM_NoII down0dEX_NoII

foreach name of local columns {
	estimates use "$output_dta/`name'" 	//Original model with all Proxies.
	estimates store `name' 				//Store results to create columns below.
}

* Tex
estout `columns' using "$output_tex/`table'.tex", replace drop(omega shh* sub* J) ///
		cells(b(star fmt(3)) se(par fmt(3))) starlevels($^{\ast}$ .10 $^{\ast\ast}$ .05 $^{\ast\ast\ast}$ .01) ///
		stats(N, labels("Observations") fmt(%9.0fc)) mlabels(, none) collabels(, none) eqlabels(, none) ///
		rename(downOFF "$\!{downIM}_{jct-1}\$" upIN "$\!{upEX}_{jct-1}\$" upOFF "$\!{upIM}_{jct-1}\$" downIN "$\!{downEX}_{jct-1}\$" offshoring "$\!{IM}_{jct-1}\$" inshoring "$\!{EX}_{jct-1}\$") ///
		varlabels(, end(\addlinespace) nolast elist("$\!{EX}_{jct-1}\$" \midrule)) style(tex) substitute("\!" "")

* Log
cap log using "$output_log/`table'.log", replace
estout `columns', cells(b(star fmt(3)) se(par fmt(3))) starlevels(* .10 ** .05 *** .01) stats(N, labels("Observations") fmt(%9.0fc)) drop(J)
cap log close

*===============================================================================
* Online Appendix Table - Robustness
*===============================================================================
local table OnlineAppendix_TableD4
local columns Baseline ProxiesWith0d Proxies0dBroad SizeSmall SizeLarge Size_D Bacon15 Bootstraps Cluster_j Cluster_c Cluster_i

foreach name of local columns {
	estimates use "$output_dta/`name'" 	//Original model with all Proxies.
	estimates store `name' 				//Store results to create columns below.
}

* Tex
estout `columns' using "$output_tex/`table'.tex", replace drop(omega offsh* insh* shh* sub* J) ///
		cells(b(star fmt(3)) se(par fmt(3))) starlevels($^{\ast}$ .10 $^{\ast\ast}$ .05 $^{\ast\ast\ast}$ .01) ///
		stats(N, labels("Observations") fmt(%9.0fc)) mlabels(, none) collabels(, none) eqlabels(, none) ///
		rename(downOFF "$\!{downIM}_{jct-1}\$" upIN "$\!{upEX}_{jct-1}\$" upOFF "$\!{upIM}_{jct-1}\$" downIN "$\!{downEX}_{jct-1}\$" ///
			 downOFF_D "$\!D*{downIM}_{jct-1}\$" upIN_D "$\!D*{upEX}_{jct-1}\$" upOFF_D "$\!D*{upIM}_{jct-1}\$" downIN_D "$\!D*{downEX}_{jct-1}\$") ///
		varlabels(, end(\addlinespace) nolast elist("$\!D*{downEX}_{jct-1}\$" \midrule)) style(tex) substitute("\!" "") 

* Log
cap log using "$output_log/`table'.log", replace
estout `columns', cells(b(star fmt(3)) se(par fmt(3))) starlevels(* .10 ** .05 *** .01) stats(N, labels("Observations") fmt(%9.0fc)) drop(J)
cap log close

*===============================================================================
* Online Appendix Table - Heterogeneity with sample splits
*===============================================================================
local table OnlineAppendix_TableD5
local columns Baseline DomesticLinks NoDomesticLinks Downstream Upstream LowTech HighTech L K DownstreamLowTech DownstreamHighTech DownstreamL DownstreamK

foreach name of local columns {
	estimates use "$output_dta/`name'" 	//Original model with all Proxies.
	estimates store `name' 				//Store results to create columns below.
}

* Tex
estout `columns' using "$output_tex/`table'.tex", replace drop(omega offsh* insh* shh* sub* J) ///
		cells(b(star fmt(3)) se(par fmt(3))) starlevels($^{\ast}$ .10 $^{\ast\ast}$ .05 $^{\ast\ast\ast}$ .01) ///
		stats(N, labels("Observations") fmt(%9.0fc)) mlabels(, none) collabels(, none) eqlabels(, none) ///
		rename(downOFF "$\!{downIM}_{jct-1}\$" upIN "$\!{upEX}_{jct-1}\$" upOFF "$\!{upIM}_{jct-1}\$" downIN "$\!{downEX}_{jct-1}\$") ///
		varlabels(, end(\addlinespace) nolast elist("$\!{downEX}_{jct-1}\$" \midrule)) style(tex) substitute("\!" "") 

* Log
cap log using "$output_log/`table'.log", replace
estout `columns', cells(b(star fmt(3)) se(par fmt(3))) starlevels(* .10 ** .05 *** .01) stats(N, labels("Observations") fmt(%9.0fc)) drop(J)
cap log close

*===============================================================================
* Online Appendix Table - Additional Heterogeneity
*===============================================================================
local table OnlineAppendix_TableD6
local columns Baseline LowTech_D_CEEC LowTech_D_WEC

foreach name of local columns {
	estimates use "$output_dta/`name'" 	//Original model with all Proxies.
	estimates store `name' 				//Store results to create columns below.
}

* Tex
estout `columns' using "$output_tex/`table'.tex", replace drop(omega* offsh* insh* shh* sub* J) ///
		cells(b(star fmt(3)) se(par fmt(3))) starlevels($^{\ast}$ .10 $^{\ast\ast}$ .05 $^{\ast\ast\ast}$ .01) ///
		stats(N, labels("Observations") fmt(%9.0fc)) mlabels(, none) collabels(, none) eqlabels(, none) ///
		rename(downOFF "$\!{downIM}_{jct-1}\$" upIN "$\!{upEX}_{jct-1}\$" upOFF "$\!{upIM}_{jct-1}\$" downIN "$\!{downEX}_{jct-1}\$" ///
			 downOFF_D "$\!D*{downIM}_{jct-1}\$" upIN_D "$\!D*{upEX}_{jct-1}\$" upOFF_D "$\!D*{upIM}_{jct-1}\$" downIN_D "$\!D*{downEX}_{jct-1}\$") ///
		varlabels(, end(\addlinespace) nolast elist("$\!D*{downEX}_{jct-1}\$" \midrule)) style(tex) substitute("\!" "")

* Log
cap log using "$output_log/`table'.log", replace
estout `columns', cells(b(star fmt(3)) se(par fmt(3))) starlevels(* .10 ** .05 *** .01) stats(N, labels("Observations") fmt(%9.0fc)) drop(J)
cap log close
